#include <omp.h>
#include <stdio.h>
int main() {
    int count = 0;
    omp_lock_t lock;
    // Initialize the lock
    omp_init_lock(&lock);
    // Parallel region with lock to control access to 'count'
    #pragma omp parallel for num_threads(5)
    for (int i = 0; i < 100000; i++) {
        // Acquire the lock before modifying 'count'
       omp_set_lock(&lock);
        count++;  // Critical section
       //  Release the lock after modification
       omp_unset_lock(&lock);
    }

    // Destroy the lock after use
    omp_destroy_lock(&lock);
    printf("Final count: %d\n", count);
    return 0;
}
